/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.wathe.cca;

import dev.doctor4t.wathe.Wathe;
import dev.doctor4t.wathe.cca.PlayerPsychoComponent;
import dev.doctor4t.wathe.cca.WorldBlackoutComponent;
import dev.doctor4t.wathe.game.GameConstants;
import dev.doctor4t.wathe.index.WatheItems;
import dev.doctor4t.wathe.index.WatheSounds;
import dev.doctor4t.wathe.util.ShopEntry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2767;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.ComponentRegistry;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.ClientTickingComponent;
import org.ladysnake.cca.api.v3.component.tick.ServerTickingComponent;

public class PlayerShopComponent
implements AutoSyncedComponent,
ServerTickingComponent,
ClientTickingComponent {
    public static final ComponentKey<PlayerShopComponent> KEY = ComponentRegistry.getOrCreate((class_2960)Wathe.id("shop"), PlayerShopComponent.class);
    private final class_1657 player;
    public int balance = 0;

    public PlayerShopComponent(class_1657 player) {
        this.player = player;
    }

    public void sync() {
        KEY.sync((Object)this.player);
    }

    public void reset() {
        this.balance = 0;
        this.sync();
    }

    public void addToBalance(int amount) {
        this.setBalance(this.balance + amount);
    }

    public void setBalance(int amount) {
        this.balance = amount;
        this.sync();
    }

    public void tryBuy(int index) {
        if (index < 0 || index >= GameConstants.SHOP_ENTRIES.size()) {
            return;
        }
        ShopEntry entry = GameConstants.SHOP_ENTRIES.get(index);
        if (FabricLoader.getInstance().isDevelopmentEnvironment() && this.balance < entry.price()) {
            this.balance = entry.price() * 10;
        }
        if (this.balance >= entry.price() && !this.player.method_7357().method_7904(entry.stack().method_7909()) && entry.onBuy(this.player)) {
            this.balance -= entry.price();
            class_1657 class_16572 = this.player;
            if (class_16572 instanceof class_3222) {
                class_3222 player = (class_3222)class_16572;
                player.field_13987.method_14364((class_2596)new class_2767(class_7923.field_41172.method_47983((Object)WatheSounds.UI_SHOP_BUY), class_3419.field_15248, player.method_23317(), player.method_23318(), player.method_23321(), 1.0f, 0.9f + this.player.method_59922().method_43057() * 0.2f, player.method_59922().method_43055()));
            }
        } else {
            this.player.method_7353((class_2561)class_2561.method_43470((String)"Purchase Failed").method_27692(class_124.field_1079), true);
            class_1657 class_16573 = this.player;
            if (class_16573 instanceof class_3222) {
                class_3222 player = (class_3222)class_16573;
                player.field_13987.method_14364((class_2596)new class_2767(class_7923.field_41172.method_47983((Object)WatheSounds.UI_SHOP_BUY_FAIL), class_3419.field_15248, player.method_23317(), player.method_23318(), player.method_23321(), 1.0f, 0.9f + this.player.method_59922().method_43057() * 0.2f, player.method_59922().method_43055()));
            }
        }
        this.sync();
    }

    public void clientTick() {
    }

    public void serverTick() {
    }

    public static boolean useBlackout(@NotNull class_1657 player) {
        player.method_7357().method_7906(WatheItems.BLACKOUT, GameConstants.ITEM_COOLDOWNS.getOrDefault(WatheItems.BLACKOUT, 0).intValue());
        return ((WorldBlackoutComponent)WorldBlackoutComponent.KEY.get((Object)player.method_37908())).triggerBlackout();
    }

    public static boolean usePsychoMode(@NotNull class_1657 player) {
        player.method_7357().method_7906(WatheItems.PSYCHO_MODE, GameConstants.ITEM_COOLDOWNS.getOrDefault(WatheItems.PSYCHO_MODE, 0).intValue());
        return ((PlayerPsychoComponent)PlayerPsychoComponent.KEY.get((Object)player)).startPsycho();
    }

    public void writeToNbt(@NotNull class_2487 tag, class_7225.class_7874 registryLookup) {
        tag.method_10569("Balance", this.balance);
    }

    public void readFromNbt(@NotNull class_2487 tag, class_7225.class_7874 registryLookup) {
        this.balance = tag.method_10550("Balance");
    }
}

